{smcl}
{* *! version 24aug2022}{...}
{viewerjumpto "Syntax" "mstutil##syntax"}{...}
{viewerjumpto "Description" "mstutil##description"}{...}
{viewerjumpto "Remarks" "mstutil##remarks"}{...}
{viewerjumpto "Examples" "mstutil##examples"}{...}
{viewerjumpto "Stored results" "mstutil##results"}{...}
{viewerjumpto "Citation" "mstutil##cite"}{...}
{viewerjumpto "References" "mstutil##references"}{...}
{vieweralsosee "mstatecox commands: Overview" "help mst"}{...}
{vieweralsosee "mstsample" "help mstsample"}{...}
{vieweralsosee "mstdraw" "help mstdraw"}{...}
{vieweralsosee "" "--"}{...}
{vieweralsosee "[ST] stcox" "help stcox"}{...}
{cmd:help mstutil}{right: ({browse "https://doi.org/10.1177/1536867X241233681":SJ24-1: st0534_3})}
{hline}

{title:Title}

{p 4 16 2}
{hi:mstutil} {hline 2} Sets the data for a multistate duration analysis
{p_end}


{marker syntax}{...}
{title:Syntax}

{p 8 16 2}
{cmd:mstutil} [{cmd:,} {opt fr:om(varname)} {opt to(varname)} {opt sdur}
{opt draw(varname)}]

{synoptset 20}{...}
{synopthdr}
{synoptline}
{synopt :{opt from(varname)}}variable name for the subject's current stage;
required unless {cmd:sdur} is specified{p_end}
{synopt :{opt to(varname)}}variable name for the subject's next possible
stage(s); required unless {cmd:sdur} is specified{p_end}
{synopt :{opt sdur}}convenience option for single-duration data (that is, data
with one failure event only); automatically creates transition ID variable and "from" and "to" stage variables{p_end}
{synopt :{opt draw(varname)}}transition ID variable that enables {cmd:mstdraw} to graph saved {cmd:mstsample} results; use only for this purpose (special exception case){p_end}
{synoptline}
{p 4 6 2}
You must run {helpb stcox} before using {cmd:mstutil}.  {cmd:stcox}'s
{cmd:strata()} option must also be specified, unless {cmd:mstutil}'s
{cmd:sdur} is specified.{p_end}
{p 4 6 2}
All stage variables' values must be sequentially increasing integers beginning
at 1.  If not, Stata will return an error message.{p_end}
{p 4 6 2}
The transition ID's values need not be sequential; they only need to be integer values, as mentioned above.{p_end}


{marker description}{...}
{title:Description}

{pstd}
{cmd:mstutil} is the first command you must run to generate transition
probabilities from a Cox model.  It tells Stata which variables contain
1) the subject's current stage and 2) the next stage(s) to which a subject
could potentially transition.  The command assumes the dataset is already
formatted appropriately for a multistate analysis (see Jones and Metzger
[2018, suppl. app. A]; de Wreede, Fiocco, and Putter [2010]).


{marker remarks}{...}
{title:Remarks}

{p 4 6 2}
The transition from and to ID variables that {opt sdur} creates are named
{bf:trans__ms}, {bf:from__ms}, and {bf:to__ms}, respectively.{p_end}


{marker examples}{...}
{title:Examples}

{pstd}Single-duration data, variant 1 - nonparametric{p_end}
{phang2}{cmd:. webuse catheter}{p_end}
{phang2}{cmd:. stset time, fail(infect)}{p_end}
{phang2}{cmd:. stcox, estimate efron}{p_end}
{phang2}{cmd:. mstutil, sdur}{p_end}

{pstd}Single-duration data, variant 2 - nonparametric{p_end}
{phang2}{cmd:. webuse catheter, clear}{p_end}
{phang2}{cmd:. stset time, fail(infect)}{p_end}
{phang2}{cmd:. gen current = 1}{p_end}
{phang2}{cmd:. gen next = 2}{p_end}
{phang2}{cmd:. gen trans = 1}{p_end}
{phang2}{cmd:. stcox, estimate strata(trans) efron}{p_end}
{phang2}{cmd:. mstutil, from(current) to(next)}{p_end}

{pstd}Single-duration data, variant 1 - semiparametric{p_end}
{phang2}{cmd:. webuse catheter, clear}{p_end}
{phang2}{cmd:. stset time, fail(infect)}{p_end}
{phang2}{cmd:. stcox age female, efron}{p_end}
{phang2}{cmd:. mstutil, sdur}{p_end}

{pstd}Competing-risks data - semiparametric{p_end}
{phang2}{cmd:. webuse hypoxia, clear}{p_end}
{phang2}{cmd:. gen days = (dftime * 365.25)} {p_end}
{phang2}{cmd:// Above command puts time in days}{p_end}
{phang2}{cmd:. expand 2, gen(new)}{p_end}
{phang2}{cmd:. bysort stnum (new): gen nextStage = _n}{p_end}
{phang2}{cmd:. gen status = (nextStage==failtype)}{p_end}
{phang2}{cmd:. clonevar trans = nextStage}{p_end}
{phang2}{cmd:. gen curStg = 1}{p_end}
{phang2}{cmd:. replace nextStage = nextStage + 1}{p_end}
{phang2}{cmd:. stset days, failure(status)}{p_end}
{phang2}{cmd:. foreach x of varlist ifp tumsize pelnode{c -(} }  {p_end}
{phang3}{cmd: forvalues tr = 1/2{c -(} }  {p_end}
{p 15 19 2}{cmd: gen `x'_tr`tr' = cond(trans==`tr', `x', cond(`x'==., ., 0))} {p_end}
{phang3}{cmd: {c )-}} {p_end}
{p 10 14 2}{cmd: {c )-}} {p_end}
{phang2}{cmd:. stcox  *_tr1 *_tr2, strata(trans) efron}{p_end}
{phang2}{cmd:. mstutil, from(curStg) to(nextStage)}{p_end}

{pstd}Multistate data - nonparametric{p_end}
{phang2}{cmd:. use http://www.shawnakmetzger.com/research/2%20-%20h%26a%20-%20continuous%2c%20no%20TVC.dta, clear}{p_end}
{phang2}{cmd:. stset t, enter(t0) f(status)}{p_end}
{phang2}{cmd:. stcox, estimate strata(trans) efron}{p_end}
{phang2}{cmd:. replace stage = stage + 1}{p_end}
{phang2}{cmd:. replace nextStage = nextStage + 1}{p_end}
{phang2}{cmd:. mstutil, from(stage) to(nextStage)}{p_end}

{pstd}See {helpb mstdraw##examplesMID:mstdraw} for an example using
{cmd:mstutil, draw()}.{p_end}


{marker results}{...}
{title:Stored results}

{pstd}
In addition to the results stored by {helpb stcox}, {cmd:mstutil} stores
the following in {cmd:e()}:

{synoptset 22 tabbed}{...}
{p2col 5 15 19 2: Scalars}{p_end}
{synopt:{cmd:e(maxStgNo)}}highest stage number{p_end}
{synopt:{cmd:e(nTrans)}}number of transition IDs{p_end}
{synopt:{cmd:e(sdur)}}{cmd:1} if single-duration specified, {cmd:0}
otherwise{p_end}

{synoptset 22 tabbed}{...}
{p2col 5 15 19 2: Macros}{p_end}
{synopt:{cmd:e(trans)}}name of transition variable, from {cmd:stcox}'s
{cmd:strata()} (or from {opt draw()}, if specified){p_end}
{synopt:{cmd:e(from)}}name of variable with subject's current stage{p_end}
{synopt:{cmd:e(to)}}name of variable with subject's next possible stage(s){p_end}


{marker cite}{...}
{title:Citation}

{pstd}See the {help mst##cite:mst} help file.{p_end}


{marker references}{...}
{title:References}

{phang}
de Wreede, L. C., M. Fiocco, and H. Putter.  2010.
The mstate package for estimation and prediction in non- and semi-parametric
multi-state and competing risks models.
{it:Computer Methods and Programs in Biomedicine} 99: 261-274.{p_end}

{phang}
Jones, B. T., and S. K. Metzger.  2018.
Evaluating conflict dynamics: A novel empirical approach to stage conceptions.
{it:Journal of Conflict Resolution} 62: 819-847.{p_end}


{title:Also see}

{p 4 14 2}
Article:  {it:Stata Journal}, volume 24, number 1: {browse "https://doi.org/10.1177/1536867X241233681":st0534_3},{break}
          {it:Stata Journal}, volume 21, number 3: {browse "https://doi.org/10.1177/1536867X211045584":st0534_2},{break}
          {it:Stata Journal}, volume 19, number 3: {browse "https://doi.org/10.1177/1536867X19874265":st0534_1},{break}
          {it:Stata Journal}, volume 18, number 3: {browse "http://www.stata-journal.com/article.html?article=st0534":st0534}{p_end}

{pstd}
{bf:Last updated} - 15JAN23
{p_end}
