** Workshop-Mediation analysis **

** Part 1 ** simple mediation with cross-sectoinal data 

** explore DATASET: EGAT2/2

use "/Users/Mc/Desktop/Workshop_mediation_dataset1.dta"

count
*2532

sum perio // independent var
tab dm // mediator
tab ckd // outcome

*** causal pathway >> Powerpoint 


*********************

*** MEDIATION MODEL (model of DM)

* Set DM as the outcome, and perio (independent var) would be fixed as predictor
* Then, perform traditional stepwise for variable selection with other risk factors of DM


*** Final DM

logit dm perio i.obes i.ht i.dlp ib(3).educ // from this process, we get "a"     

***********************

*** OUTCOME MODEL (Model of CKD)

* Set CKD as the outcome, and perio (independent var) and dm (mediator) would be fixed as predictors
* Then, perform traditional stepwise for variable selection with other risk factors of CKD

*** Final CKD

logit ckd perio i.dm uric_a i.ht  // from this, we get "b & c'"




*************************************************************************************************

******* Bootstrap for 95%CI ************

** we use "GSEM" to process these 2 logit, siultaneously.


gsem (dm <- perio i.obes i.ht i.dlp ib(3).educ, logit) (ckd <- perio i.dm uric_a i.ht, logit)


** We will use Stored results of GSEM to further calculation

help gsem_command // see store results

ereturn list // see the name of matrix that we want

matlist e(b) // list vaule 

dis [dm]_b[perio]

dis [ckd]_b[1.dm]

dis [ckd]_b[perio]

***********


*** indirect effect = a*b

*** ab = [dm]_b[perio]*[ckd]_b[1.dm]

*** or_ab = exp([dm]_b[perio]*[ckd]_b[1.dm])


************* 


** direct effect = c1

** c1 = [ckd]_b[perio]

** or_c1 = exp([ckd]_b[perio])


**************


**** total effect = direct + indirect effect

** total = [ckd]_b[perio] + ([dm]_b[perio]*[ckd]_b[1.dm])

** or_total = exp([ckd]_b[perio] + ([dm]_b[perio]*[ckd]_b[1.dm]))


*******************************

program drop _all

program define indir, rclass
  gsem (dm <- perio i.obes i.ht i.dlp ib(3).educ, logit) (ckd <- perio i.dm uric_a i.ht, logit)
  return scalar a  = [dm]_b[perio]
  return scalar b  = [ckd]_b[1.dm]
  return scalar c1  = [ckd]_b[perio] 											// direct effect
  return scalar ab  = [dm]_b[perio]*[ckd]_b[1.dm] 								// indirect effect
  return scalar total  = [ckd]_b[perio] + ([dm]_b[perio]*[ckd]_b[1.dm]) 		// total effect
  return scalar or_c1  = exp([ckd]_b[perio]) 									// ORdirect effect
  return scalar or_ab  = exp([dm]_b[perio]*[ckd]_b[1.dm]) 						// ORindirect effect 
  return scalar or_total  = exp([ckd]_b[perio] + ([dm]_b[perio]*[ckd]_b[1.dm])) // ORtotal effect
end

indir

set seed 123
bootstrap r(a) r(b) r(c1) r(ab) r(total) r(or_c1) r(or_ab) r(or_total),reps(1000): indir
estat bootstrap, bc p norm


******










