dn = read.csv("D:/Journal Club/Journal Club as Presenter October 2019/R code/ANALYSIS.csv" , 
              header = TRUE,stringsAsFactors = F)
dn = as.data.frame(dn)
dn = na.omit(dn)
set.seed(80817) # Set a random seed
index = 1:nrow(dn)
testindex = sample(index, trunc(length(index)/3)) 
testset = dn[testindex, ] #Create a test (validation) dataset with 33.3$ of the data
trainset = dn[-testindex, ] #Create a trainig dataset with 66.6% of the data


x_train = data.matrix(trainset[, 2:8]) # Take the features (x) from the training dataset.
y_train = as.factor(trainset[, 9]) # Take the outcomes (y) from the training dataset.

x_test = data.matrix(testset[, 2:8]) # Take the features (x) from the testing/validation dataset.
y_test = as.factor(testset[, 9]) # Take the outcomes (y) from the testing/validation dataset.


#Support Vector Machine
require(e1071) # Load e1071 package into this R session.
## Loading required package: e1071
svm_model_train <- svm(x_train, y_train)
summary(svm_model_train)
svm_pred_train = predict(svm_model_train, x_train)

require(caret)
require(ggplot2)
require(lattice)

confusionMatrix(as.factor(svm_pred_train), as.factor(y_train))

require(pROC)
roc_svm_train = roc(as.numeric(y_train), as.numeric(svm_pred_train))
auc_svm_train = auc(roc_svm_train)
print(auc_svm_train)

#svm_pred_train = round(predict(svm_model_train, x_train, type="response"),0)
#svm_model = svm(x_train, y_train, cost = 1, gamma = c(1/(ncol(x_train)-1)), kernel="radial", cross=10)